/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class PressRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object secondInput;
    public final int secondInputCount;
    public final Object itemOutput;
    public final int itemOutputCount;
    public final float itemOutputChance;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final int energy;
    public final float experience;

    public PressRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object itemOutput, int itemOutputCount, int energy, float experience) {
        this(key, input, inputCount, null, 0, itemOutput, itemOutputCount, -1.0f, Fluids.f_76191_, 0, energy, experience);
    }

    public PressRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object itemOutput, int itemOutputCount, float itemOutputChance, int energy, float experience) {
        this(key, input, inputCount, null, 0, itemOutput, itemOutputCount, itemOutputChance, Fluids.f_76191_, 0, energy, experience);
    }

    public PressRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, int energy, float experience) {
        this(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, -1.0f, Fluids.f_76191_, 0, energy, experience);
    }

    public PressRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, float itemOutputChance, int energy, float experience) {
        this(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, itemOutputChance, Fluids.f_76191_, 0, energy, experience);
    }

    public PressRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int energy, float experience) {
        this(key, input, inputCount, secondInput, secondInputCount, itemOutput, itemOutputCount, -1.0f, fluidOutput, fluidOutputAmount, energy, experience);
    }

    public PressRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object itemOutput, int itemOutputCount, float itemOutputChance, Object fluidOutput, int fluidOutputAmount, int energy, float experience) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.secondInput = secondInput;
        this.secondInputCount = secondInputCount;
        this.itemOutput = itemOutput;
        this.itemOutputCount = itemOutputCount;
        this.itemOutputChance = itemOutputChance;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.energy = energy;
        this.experience = experience;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        Ingredient secondIng = MiscHelper.INSTANCE.getIngredient(this.secondInput);
        ItemStack itemStack = MiscHelper.INSTANCE.getItemStack(this.itemOutput, this.itemOutputCount);
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (itemStack.m_41619_() && fluidStack.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + this.itemOutput + ", " + this.fluidOutput);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "thermal:press");
        JsonArray ingsJson = new JsonArray();
        JsonObject ingJson = IntersectionIngredient.of((Ingredient[])new Ingredient[]{ing}).m_43942_().getAsJsonObject();
        ingJson.addProperty("count", (Number)this.inputCount);
        ingsJson.add((JsonElement)ingJson);
        if (secondIng != EmptyIngredient.INSTANCE) {
            JsonObject secondIngJson = IntersectionIngredient.of((Ingredient[])new Ingredient[]{secondIng}).m_43942_().getAsJsonObject();
            secondIngJson.addProperty("count", (Number)this.secondInputCount);
            ingsJson.add((JsonElement)secondIngJson);
        }
        json.add("ingredients", (JsonElement)ingsJson);
        JsonArray resultJson = new JsonArray();
        if (!itemStack.m_41619_()) {
            JsonObject itemResultJson = MiscHelper.INSTANCE.serializeItemStack(itemStack);
            itemResultJson.addProperty("chance", (Number)Float.valueOf(this.itemOutputChance));
            resultJson.add((JsonElement)itemResultJson);
        }
        if (!fluidStack.isEmpty()) {
            resultJson.add((JsonElement)MiscHelper.INSTANCE.serializeFluidStack(fluidStack));
        }
        json.add("result", (JsonElement)resultJson);
        json.addProperty("energy", (Number)this.energy);
        json.addProperty("experience", (Number)Float.valueOf(this.experience));
        return json;
    }
}

